/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.spiget.comparator;

import java.util.Arrays;

public abstract class VersionComparator {
    public static final VersionComparator EQUAL = new VersionComparator(){

        @Override
        public boolean isNewer(String currentVersion, String checkVersion) {
            return !currentVersion.equals(checkVersion);
        }
    };
    public static final VersionComparator SEM_VER = new VersionComparator(){

        @Override
        public boolean isNewer(String currentVersion, String checkVersion) {
            try {
                int[] currentVersionData = Arrays.stream(currentVersion.split("\\.")).mapToInt(Integer::parseInt).toArray();
                int[] checkVersionData = Arrays.stream(checkVersion.split("\\.")).mapToInt(Integer::parseInt).toArray();
                int i = 0;
                for (int version : checkVersionData) {
                    if (i == currentVersionData.length) {
                        return true;
                    }
                    if (version > currentVersionData[i]) {
                        return true;
                    }
                    if (version < currentVersionData[i]) {
                        return false;
                    }
                    ++i;
                }
            }
            catch (NumberFormatException e) {
                System.err.println("[SpigetUpdate] Invalid SemVer versions specified [" + currentVersion + "] [" + checkVersion + "]");
            }
            return false;
        }
    };
    public static final VersionComparator SEM_VER_SNAPSHOT = new VersionComparator(){

        @Override
        public boolean isNewer(String currentVersion, String checkVersion) {
            currentVersion = currentVersion.replace("-SNAPSHOT", "");
            checkVersion = checkVersion.replace("-SNAPSHOT", "");
            return SEM_VER.isNewer(currentVersion, checkVersion);
        }
    };

    public abstract boolean isNewer(String var1, String var2);
}

